{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitEspectroscopiLPC;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, UnitDadesGlobus2, MMSystem, StdCtrls, UnitMatematiques,
  Spin;

type
  TFormEspectroscopiLPC = class(TForm)
    Panel: TPanel;
    SpeedButtonEngegarParar: TSpeedButton;
    SpeedButtonCopiarALaCarpeta: TSpeedButton;
    Panel1: TPanel;
    MenuEscalaYDecibels: TCheckBox;
    MenuPreenfasis: TCheckBox;
    MenuNormalitzarPerMaxim: TCheckBox;
    ButtonCongelar: TButton;
    LabelColorLinea: TLabel;
    CheckBoxCanviColorAutomatic: TCheckBox;
    EditV1: TEdit;
    EditV2: TEdit;
    EditV5: TEdit;
    EditV3: TEdit;
    EditV4: TEdit;
    EditV6: TEdit;
    EditV7: TEdit;
    EditV8: TEdit;
    EditV9: TEdit;
    EditV10: TEdit;
    ButtonVocals: TButton;
    CheckBoxMel: TCheckBox;
    CheckBoxNoRepintar: TCheckBox;
    ButtonEsborrar: TButton;
    ButtonEsborrarUltim: TButton;
    SpinEditNumeroQuoeficients: TSpinEdit;
    LabelNumeroQuoeficientsLPC: TLabel;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    ButonObrirPatrons: TSpeedButton;
    ButtonGuardarPatrons: TSpeedButton;
    CheckBoxMostrarSoReconegut: TCheckBox;
    SpeedButtonCaixaEines: TSpeedButton;
    CheckBoxEscalaMelLineal: TCheckBox;
    Bevel2: TBevel;
    Bevel1: TBevel;
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure SpeedButtonEngegarPararClick(Sender: TObject);
    procedure SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure MenuEscalaYDecibelsClick(Sender: TObject);
    procedure MenuPreenfasisClick(Sender: TObject);
    procedure MenuNormalitzarPerMaximClick(Sender: TObject);
    procedure ButtonCongelarClick(Sender: TObject);
    procedure ButtonEsborrarClick(Sender: TObject);
    procedure LabelColorLineaClick(Sender: TObject);
    procedure ButtonEsborrarUltimClick(Sender: TObject);
    procedure ButtonVocalsClick(Sender: TObject);
    procedure CheckBoxMelClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CheckBoxCanviColorAutomaticClick(Sender: TObject);
    procedure CheckBoxNoRepintarClick(Sender: TObject);
    procedure SpinEditNumeroQuoeficientsChange(Sender: TObject);
    procedure ButtonGuardarPatronsClick(Sender: TObject);
    procedure ButonObrirPatronsClick(Sender: TObject);
    procedure CheckBoxMostrarSoReconegutClick(Sender: TObject);
    procedure SpeedButtonCaixaEinesClick(Sender: TObject);
    procedure CheckBoxEscalaMelLinealClick(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
    procedure LabelColorLineaMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
    procedure WMWIMDATA(var Msg: TMessage); message MM_WIM_DATA;
  public
    { Public declarations }
    ValorMaximDelSo:integer;
    UnitatEixX:LongInt;
    UnitatEixY:LongInt;
    NumeroQuoeficientsLPC:integer;
    SizeText:integer;
    ValorMinimDeSo:integer;
    VocalReconegudaAnterior:string;
    procedure Pintar;
  end;

var
  FormEspectroscopiLPC: TFormEspectroscopiLPC;

{************************************************}
IMPLEMENTATION
{************************************************}

Uses UnitTools, UnitEntradaDeSo, UnitDades, UnitCalculsLPC, UnitCalculsMatematics,
  UnitFormPrincipal, Unitabout, UnitCanviDeParametres;

{$R *.DFM}

var
  NumeroLineas:integer;
  //Numeros:array[0..100] of NumerosPerCalcular;
  Numeros:array[0..100] of EntersPerCalcular;
  ColorLineas:array[0..100] of TColor;

procedure TFormEspectroscopiLPC.FormCreate(Sender: TObject);
var
  i:integer;
begin
  ValorMaximDelSo:=0;
  UnitatEixX:=1000;
  NumeroLineas:=0;
  for i:=0 to 100 do ColorLineas[i]:=ClBlack;
  IniciarDadesEntradaDeSo;
  GrandariaBytesBufferEntradaDeSo:=512;
  BitsPerMostraEntradaSo:=16;
  FrequenciaDeMostreigEntradaSo:=11025;
  EngegarProcesEntradaDeSo(Handle);
  FinalitzarEntradaDeSo;
  SizeText:=Canvas.Font.Size;
  //ValorMinimDeSo:=1;
  ValorMinimDeSo:=15*256;
  VocalReconegudaAnterior:='';
end;

procedure TFormEspectroscopiLPC.FormPaint(Sender: TObject);
begin
  Pintar;
end;

procedure TFormEspectroscopiLPC.FormResize(Sender: TObject);
begin
  Repaint;
end;

procedure TFormEspectroscopiLPC.SpeedButtonEngegarPararClick(Sender: TObject);
begin
   if SpeedButtonEngegarParar.Down then begin
    IniciarDadesEntradaDeSo;
    GrandariaBytesBufferEntradaDeSo:=512;
    BitsPerMostraEntradaSo:=16;
    FrequenciaDeMostreigEntradaSo:=11025;
    VocalReconegudaAnterior:='';
    //Repaint;
    if CheckBoxNoRepintar.Checked then Pintar else Repaint;
    ValorMinimDeSo:=StrToInt(FormCanviDeParametres.EditMinim.Text)*256;
    if EngegarProcesEntradaDeSo(Handle)=0 then SpeedButtonEngegarParar.Caption:='P';
  end else begin
    SpeedButtonEngegarParar.Caption:='E';
    FinalitzarEntradaDeSo;
  end;
end;

procedure TFormEspectroscopiLPC.FormClose(Sender: TObject;var Action: TCloseAction);
begin
  if SpeedButtonEngegarParar.Down then begin
    FinalitzarEntradaDeSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
    SpeedButtonEngegarParar.Enabled:=true;
  end;
end;

procedure TFormEspectroscopiLPC.WMWIMDATA(var Msg: TMessage);
var
  i:integer;
begin
  if ParoProcesContinuEntradaDeSo then exit;
  ValorMaximDelSo:=ValorMaximDetectatEntradaDeSo;
  for i:=1 to GrandariaNumerosBufferEntradaDeSo do Numeros[0,i]:=NumerosEntradaDeSo[i];
  //if ValorMaximDelSo>0 then begin
  if ValorMaximDelSo>ValorMinimDeSo then begin
    if CheckBoxNoRepintar.Checked then Pintar else Repaint;
  end else begin
    {
    EditV1.Font.Color:=ClBlack;
    EditV2.Font.Color:=ClBlack;
    EditV3.Font.Color:=ClBlack;
    EditV4.Font.Color:=ClBlack;
    EditV5.Font.Color:=ClBlack;
    EditV6.Font.Color:=ClBlack;
    EditV7.Font.Color:=ClBlack;
    EditV8.Font.Color:=ClBlack;
    EditV9.Font.Color:=ClBlack;
    EditV10.Font.Color:=ClBlack;
    }
  end;
end;

procedure TFormEspectroscopiLPC.SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
var
  Rect:TRect;
begin
  Rect.Left:=0;
  Rect.Top:=Panel.Height;
  Rect.Right:=ClientRect.Right;
  Rect.Bottom:=ClientRect.Bottom;
  CopiarPartDeLaFinestraALaCarpeta(Handle,Rect);
end;

procedure TFormEspectroscopiLPC.MenuEscalaYDecibelsClick(Sender: TObject);
begin
  VocalReconegudaAnterior:='';
  Repaint;
  if MenuEscalaYDecibels.Checked then
   writePrivateProfileString('Comparacio de patrons','Escala Y Decibels','SI','globus3.ini')
  else
   writePrivateProfileString('Comparacio de patrons','Escala Y Decibels','NO','globus3.ini')
end;

procedure TFormEspectroscopiLPC.MenuPreenfasisClick(Sender: TObject);
begin
  VocalReconegudaAnterior:='';
  Repaint;
  if MenuPreenfasis.Checked then
   writePrivateProfileString('Comparacio de patrons','Preenfasis','SI','globus3.ini')
  else
   writePrivateProfileString('Comparacio de patrons','Preenfasis','NO','globus3.ini')
end;

procedure TFormEspectroscopiLPC.MenuNormalitzarPerMaximClick(Sender: TObject);
begin
  VocalReconegudaAnterior:='';
  Repaint;
  if MenuNormalitzarPerMaxim.Checked then
   writePrivateProfileString('Comparacio de patrons','Normalitzar Per Maxim','SI','globus3.ini')
  else
   writePrivateProfileString('Comparacio de patrons','Normalitzar Per Maxim','NO','globus3.ini')
end;

procedure TFormEspectroscopiLPC.CheckBoxMelClick(Sender: TObject);
begin
  VocalReconegudaAnterior:='';
  Repaint;
  if CheckBoxMel.Checked then
   writePrivateProfileString('Comparacio de patrons','Mel','SI','globus3.ini')
  else
   writePrivateProfileString('Comparacio de patrons','Mel','NO','globus3.ini')
end;

procedure TFormEspectroscopiLPC.CheckBoxMostrarSoReconegutClick(Sender: TObject);
begin
  VocalReconegudaAnterior:='';
  Repaint;
  if CheckBoxMostrarSoReconegut.Checked then
   writePrivateProfileString('Comparacio de patrons','Mostrar so reconegut','SI','globus3.ini')
  else
   writePrivateProfileString('Comparacio de patrons','Mostrar so reconegut','NO','globus3.ini')
end;

procedure TFormEspectroscopiLPC.CheckBoxCanviColorAutomaticClick(Sender: TObject);
begin
  if CheckBoxCanviColorAutomatic.Checked then
   writePrivateProfileString('Comparacio de patrons','Canvi Color Automatic','SI','globus3.ini')
  else
   writePrivateProfileString('Comparacio de patrons','Canvi Color Automatic','NO','globus3.ini')
end;

procedure TFormEspectroscopiLPC.CheckBoxNoRepintarClick(Sender: TObject);
begin
  VocalReconegudaAnterior:='';
  if CheckBoxNoRepintar.Checked then
   writePrivateProfileString('Comparacio de patrons','No repintar','SI','globus3.ini')
  else
   writePrivateProfileString('Comparacio de patrons','No repintar','NO','globus3.ini')
end;

procedure TFormEspectroscopiLPC.SpinEditNumeroQuoeficientsChange(Sender: TObject);
begin
  writePrivateProfileString('Comparacio de patrons','Numero de quoeficients',PChar(IntToStr(SpinEditNumeroQuoeficients.Value)),'globus3.ini');
  VocalReconegudaAnterior:='';
  Repaint;
end;

procedure TFormEspectroscopiLPC.ButtonCongelarClick(Sender: TObject);
var
  i:integer;
begin
  if NumeroLineas>=100 then exit;
  Inc(NumeroLineas);
  ColorLineas[NumeroLineas]:=ColorLineas[0];
  for i:=1 to GrandariaNumerosBufferEntradaDeSo do Numeros[NumeroLineas,i]:=NumerosEntradaDeSo[i];
  if CheckBoxCanviColorAutomatic.Checked then LabelColorLineaClick(nil);
end;

procedure TFormEspectroscopiLPC.LabelColorLineaClick(Sender: TObject);
begin
  if ColorLineas[0]=ClBlack then begin
    ColorLineas[0]:=ClBlue;
    LabelColorLinea.Color:=ClBlue;
  end else if ColorLineas[0]=ClBlue then begin
    ColorLineas[0]:=ClRed;
    LabelColorLinea.Color:=ClRed;
  end else if ColorLineas[0]=ClRed then begin
    ColorLineas[0]:=ClGreen;
    LabelColorLinea.Color:=ClGreen;
  end else if ColorLineas[0]=ClGreen then begin
    ColorLineas[0]:=ClFuchsia;
    LabelColorLinea.Color:=ClFuchsia;
  end else if ColorLineas[0]=ClFuchsia then begin
    ColorLineas[0]:=ClYellow;
    LabelColorLinea.Color:=ClYellow;
  end else if ColorLineas[0]=ClYellow then begin
    ColorLineas[0]:=ClTeal;
    LabelColorLinea.Color:=ClTeal;
  end else if ColorLineas[0]=ClTeal then begin
    ColorLineas[0]:=ClMaroon;
    LabelColorLinea.Color:=ClMaroon;
  end else if ColorLineas[0]=ClMaroon then begin
    ColorLineas[0]:=ClBlack;
    LabelColorLinea.Color:=ClBlack;
  end;
end;

procedure TFormEspectroscopiLPC.ButtonEsborrarClick(Sender: TObject);
var
  i:integer;
begin
  NumeroLineas:=0;
  EditV1.Font.Color:=ClBlack;
  EditV2.Font.Color:=ClBlack;
  EditV3.Font.Color:=ClBlack;
  EditV4.Font.Color:=ClBlack;
  EditV5.Font.Color:=ClBlack;
  EditV6.Font.Color:=ClBlack;
  EditV7.Font.Color:=ClBlack;
  EditV8.Font.Color:=ClBlack;
  EditV9.Font.Color:=ClBlack;
  EditV10.Font.Color:=ClBlack;
  for i:=1 to GrandariaNumerosBufferEntradaDeSo do Numeros[0,i]:=0;
  ValorMaximDelSo:=0;
  VocalReconegudaAnterior:='';
  Repaint;
end;

procedure TFormEspectroscopiLPC.ButtonEsborrarUltimClick(Sender: TObject);
begin
  if NumeroLineas>0 then begin
    dec(NumeroLineas);
    VocalReconegudaAnterior:='';
    Repaint;
  end;
end;

procedure TFormEspectroscopiLPC.ButtonVocalsClick(Sender: TObject);
begin
  if FormPrincipal.MenuCatala.Checked then begin
    EditV1.Text:='A';
    EditV2.Text:='AE';
    EditV3.Text:='';
    EditV4.Text:='';
    EditV5.Text:='I';
    EditV6.Text:='O';
    EditV7.Text:='U';
    EditV8.Text:='';
    EditV9.Text:='';
    EditV10.Text:='';
  end else begin
    EditV1.Text:='A';
    EditV2.Text:='E';
    EditV3.Text:='I';
    EditV4.Text:='O';
    EditV5.Text:='U';
    EditV6.Text:='';
    EditV7.Text:='';
    EditV8.Text:='';
    EditV9.Text:='';
    EditV10.Text:='';
  end;
end;

type
  Funcio=array[1..1000]of single;

Function InterpolarFuncio(var fx1,fy1,fx2,fy2:funcio;p1,p2:integer):integer;
  Function InterpolacioLineal(y1,y2,x2,dx:single):single;
  begin
    InterpolacioLineal:=y1+(y2-y1)*dx/x2;
  end;
var
  i,n:integer;
  c:single;
  y1,y2,x1,dx:single;
begin
  InterpolarFuncio:=0;
  fx2[1]:=fx1[1];
  fy2[1]:=fy1[1];
  fx2[p2]:=fx1[p1];
  fy2[p2]:=fy1[p1];
  c:=(fx1[p1]-fx1[1])/(p2-1);
  for i:=2 to p2-1 do begin
    fx2[i]:=fx1[1]+c*(i-1);
    for n:=1 to p1-1 do begin
      if (fx2[i]>=fx1[n]) and (fx2[i]<fx1[n+1]) then begin
      //if (fx2[i]>=fx1[n]) then begin
        y1:=fy1[n];
        y2:=fy1[n+1];
        x1:=fx1[n+1]-fx1[n];
        dx:=fx2[i]-fx1[n];
        fy2[i]:=InterpolacioLineal(y1,y2,x1,dx);
        break;
      end;
    end;
  end;
end;

procedure TFormEspectroscopiLPC.Pintar;
var
  i,n,k:integer;
  Sota:integer;
  inci:Single;
  StrFrec:string;
  Escala:Real;
  NumerosPerCalcularFFT:NumerosPerCalcular;
  NumeroDeDadesInicialsLPC:integer;
  NumeroPuntsFuncioDeTransferencia:integer;
  NumerosPerCalcularLPC:NumerosEntradaLPC;
  FuncioDeTransferenciaLPCX,FuncioDeTransferenciaLPCY,FuncioDeTransferenciaLPCY0:NumerosPerCalcular;
  //FactorAugment:single;
  Diferencia:array[1..100] of single;
  MinimDiferencia:single;
  MinimDiferenciak:integer;
  Comodi:integer;
  fx1,fy1,fx2,fy2:funcio;
const
  vint = 80;
begin
  //Espectroscopi
  if CheckBoxMel.Checked then UnitatEixX:=500 else UnitatEixX:=1000;
  UnitatEixY:=1;
  Sota:=ClientHeight-120;
  {Eix X}
  Canvas.Brush.Style:=bsSolid;
  Canvas.Font.Size:=SizeText;
  Canvas.Font.Color:=clBlack;
  Canvas.Pen.Color:=RGB(128,128,128);
  Canvas.MoveTo(0,Sota);
  Canvas.LineTo(ClientRect.Right,Sota);
  inci:=10;
  i:=1;
  while round(i*inci)<ClientRect.Right do begin
    Canvas.MoveTo(round(i*inci),Sota-2);
    Canvas.LineTo(round(i*inci),Sota+2);
    inc(i);
  end;
  Canvas.textOut(10,ClientRect.Bottom-Panel1.Height-28-40,'Hertz');
  inci:=inci*10;
  i:=1;
  while round(i*inci)<ClientRect.Right do begin
    Canvas.MoveTo(round(i*inci),0);
    Canvas.LineTo(round(i*inci),Sota+5);
    if CheckBoxMel.Checked then begin
      //Invers escala mel f = 700 [exp(m / 1127) - 1]
      str(700*(exp(i*UnitatEixX/1127)-1):4:0,StrFrec);
      Canvas.textOut(round(i*inci)-round(Canvas.TextWidth(StrFrec)/2),ClientRect.Bottom-Panel1.Height-28-40,StrFrec);
    end else begin
      StrFrec:=IntToStr(i*UnitatEixX);
      Canvas.textOut(round(i*inci)-round(Canvas.TextWidth(StrFrec)/2),ClientRect.Bottom-Panel1.Height-28-40,StrFrec);
    end;
    inc(i);
  end;
  {Eix Y}
  i:=Sota-vint;
  n:=1;
  while i>0 do begin
    Canvas.MoveTo(0,i);
    Canvas.LineTo(ClientRect.Right,i);
    if MenuEscalaYDecibels.Checked then begin
      //StrFrec:=IntToStr((n*12-120));
      StrFrec:=IntToStr((n*12-72));
    end else begin
      StrFrec:=FloatToStr(n*UnitatEixY);
    end;
    Canvas.TextOut(ClientRect.Right-2-canvas.TextWidth(StrFrec),i-8,StrFrec);
    i:=i-vint;
    inc(n);
  end;
  if (VocalReconegudaAnterior<>'') and (CheckBoxMostrarSoReconegut.Checked) then begin
    Canvas.Brush.Style:=bsClear;
    Canvas.Font.Color:=clBlack;
    Canvas.Font.Name:='CourierNew';
    Canvas.Font.Size:=128;
    Canvas.textOut(ClientWidth div 2-Canvas.TextWidth(VocalReconegudaAnterior) div 2,Panel1.Height,VocalReconegudaAnterior);
  end;
  if MenuEscalaYDecibels.Checked then begin
    Escala:=UnitatEixY*vint/12;
  end else begin
    Escala:=vint;
  end;
  NumeroDeDadesInicialsLPC:=GrandariaNumerosBufferEntradaDeSo;
  //NumeroPuntsFuncioDeTransferencia:=512;
  NumeroPuntsFuncioDeTransferencia:=256;
  NumeroQuoeficientsLPC:=SpinEditNumeroQuoeficients.Value;
  if FrequenciaDeMostreigEntradaSo=22050 then begin
    NumeroQuoeficientsLPC:=2*NumeroQuoeficientsLPC;
  end else if FrequenciaDeMostreigEntradaSo=44100 then begin
    NumeroQuoeficientsLPC:=4*NumeroQuoeficientsLPC;
  end;
  for k:=0 to NumeroLineas do Diferencia[k]:=0;
  for k:=0 to NumeroLineas do begin
    if not((k=0) and (ValorMaximDelSo<ValorMinimDeSo)) then begin
      for i:=1 to GrandariaNumerosBufferEntradaDeSo do NumerosPerCalcularFFT[i]:=Numeros[k,i];
      if MenuPreenfasis.Checked then CalcularPreenfasis(NumerosPerCalcularFFT,GrandariaNumerosBufferEntradaDeSo);
      CalcularFinestraDeHamming(NumerosPerCalcularFFT,GrandariaNumerosBufferEntradaDeSo);
      for i:=1 to NumeroDeDadesInicialsLPC do NumerosPerCalcularLPC[i-1]:=NumerosPerCalcularFFT[i];
      CalculFuncioTransferenciaLPC(NumeroDeDadesInicialsLPC,NumerosPerCalcularLPC,NumeroQuoeficientsLPC,NumeroPuntsFuncioDeTransferencia,FuncioDeTransferenciaLPCX,FuncioDeTransferenciaLPCY);
      //if MenuAdaptadaALOida.Checked then CalcularAdaptacioALOida(NumeroPuntsFuncioDeTransferencia,true,FuncioDeTransferenciaLPCX,FuncioDeTransferenciaLPCY);
      for i:=1 to NumeroPuntsFuncioDeTransferencia do FuncioDeTransferenciaLPCY[i]:=FuncioDeTransferenciaLPCY[i]/8;
      //if MenuNormalitzarPerSuma.Checked then NormalitzarSumaQuoeficients(NumeroPuntsFuncioDeTransferencia,200*FactorAugment,FuncioDeTransferenciaLPCY);
      if MenuNormalitzarPerMaxim.Checked then NormalitzarQuoeficientsPerMaxim(NumeroPuntsFuncioDeTransferencia,4,FuncioDeTransferenciaLPCY);
      if MenuEscalaYDecibels.Checked then CalcularDecibelsAlsQuoeficients(NumeroPuntsFuncioDeTransferencia,FuncioDeTransferenciaLPCY);
      if CheckBoxMel.Checked then begin
        CalcularQuoeficientsXAEscalaMel(NumeroPuntsFuncioDeTransferencia,FuncioDeTransferenciaLPCX);
        //Caption:=IntToStr(Round(FuncioDeTransferenciaLPCX[1]))+'-'+IntToStr(Round(FuncioDeTransferenciaLPCX[2]))+'-'+IntToStr(Round(FuncioDeTransferenciaLPCX[NumeroPuntsFuncioDeTransferencia-1]))+'-'+IntToStr(Round(FuncioDeTransferenciaLPCX[NumeroPuntsFuncioDeTransferencia]));

        //if CheckBoxEscalaMelLineal.Checked then begin
          for i:=1 to NumeroPuntsFuncioDeTransferencia do fx1[i]:=FuncioDeTransferenciaLPCX[i];
          for i:=1 to NumeroPuntsFuncioDeTransferencia do fy1[i]:=FuncioDeTransferenciaLPCY[i];
          InterPolarFuncio(fx1,fy1,fx2,fy2,NumeroPuntsFuncioDeTransferencia,NumeroPuntsFuncioDeTransferencia);
          //Aix dna un error en l'ltim punt que per a totes les lnees agafa el valor de l'ltim del so ltim gravat
          //NumeroPuntsFuncioDeTransferencia:=128;
          //InterPolarFuncio(fx1,fy1,fx2,fy2,512,NumeroPuntsFuncioDeTransferencia);
          for i:=1 to NumeroPuntsFuncioDeTransferencia do FuncioDeTransferenciaLPCX[i]:=fx2[i];
          for i:=1 to NumeroPuntsFuncioDeTransferencia do FuncioDeTransferenciaLPCY[i]:=fy2[i];
        //end;

      end;
      {
      if MenuNormalitzarPerMaxim.Checked and MenuRealssatEscalaYDecibels.Checked and MenuEscalaYDecibels.Checked then begin
        NormalitzarQuoeficientsPerMaxim(NumeroPuntsFuncioDeTransferencia,255,FuncioDeTransferenciaLPCY);
        MinimYDecibels:=255;
        for n:=1 to NumeroPuntsFuncioDeTransferencia do if FuncioDeTransferenciaLPCY[n]<MinimYDecibels then MinimYDecibels:=FuncioDeTransferenciaLPCY[n];
        for n:=1 to NumeroPuntsFuncioDeTransferencia do FuncioDeTransferenciaLPCY[n]:=FuncioDeTransferenciaLPCY[n]-MinimYDecibels;
        NormalitzarQuoeficientsPerMaxim(NumeroPuntsFuncioDeTransferencia,100,FuncioDeTransferenciaLPCY);
      end;
      }
      //Canvas.Pen.Color:=ClFuchsia;
      Canvas.Pen.Color:=ColorLineas[k];
      if MenuEscalaYDecibels.Checked then begin
        Canvas.MoveTo(round(FuncioDeTransferenciaLPCX[1]/UnitatEixX*100),Sota-round(FuncioDeTransferenciaLPCY[1]*Escala/UnitatEixY)+4*vint);
        for i:=2 to NumeroPuntsFuncioDeTransferencia do begin
          //Canvas.MoveTo(round(FuncioDeTransferenciaLPCX[i]/UnitatEixX*100),Sota);
          Canvas.LineTo(round(FuncioDeTransferenciaLPCX[i]/UnitatEixX*100),Sota-round(FuncioDeTransferenciaLPCY[i]*Escala/UnitatEixY)+4*vint);
        end;
      end else begin
        Canvas.MoveTo(round(FuncioDeTransferenciaLPCX[1]/UnitatEixX*100),Sota-round(FuncioDeTransferenciaLPCY[1]*Escala/UnitatEixY));
        for i:=2 to NumeroPuntsFuncioDeTransferencia do begin
          //Canvas.MoveTo(round(FuncioDeTransferenciaLPCX[i]/UnitatEixX*100),Sota);
          Canvas.LineTo(round(FuncioDeTransferenciaLPCX[i]/UnitatEixX*100),Sota-round(FuncioDeTransferenciaLPCY[i]*Escala/UnitatEixY));
        end;
      end;
    end;
    if ValorMaximDelSo>ValorMinimDeSo then begin
      if k=0 then begin
        NormalitzarSumaQuoeficients(NumeroPuntsFuncioDeTransferencia,400,FuncioDeTransferenciaLPCY);
        for i:=1 to NumeroPuntsFuncioDeTransferencia do FuncioDeTransferenciaLPCY0[i]:=FuncioDeTransferenciaLPCY[i];
      end else if k<=10 then begin
        NormalitzarSumaQuoeficients(NumeroPuntsFuncioDeTransferencia,400,FuncioDeTransferenciaLPCY);
        Diferencia[k]:=0;
        for i:=1 to NumeroPuntsFuncioDeTransferencia do Diferencia[k]:=Diferencia[k]+abs(FuncioDeTransferenciaLPCY[i]-FuncioDeTransferenciaLPCY0[i]);
        if MenuEscalaYDecibels.Checked then Comodi:=1 else Comodi:=10;
        Canvas.MoveTo(15+27*(k-1),ClientHeight-Panel1.Height);
        Canvas.LineTo(15+27*(k-1),ClientHeight-Panel1.Height-Round(Diferencia[k]/comodi));
        Canvas.MoveTo(15+27*(k-1)+1,ClientHeight-Panel1.Height);
        Canvas.LineTo(15+27*(k-1)+1,ClientHeight-Panel1.Height-Round(Diferencia[k]/comodi));
        Canvas.MoveTo(15+27*(k-1)+2,ClientHeight-Panel1.Height);
        Canvas.LineTo(15+27*(k-1)+2,ClientHeight-Panel1.Height-Round(Diferencia[k]/comodi));
      end;
    end;
  end;
  if ValorMaximDelSo>ValorMinimDeSo then begin
    if NumeroLineas>=1 then begin
      MinimDiferencia:=Diferencia[1];
      MinimDiferenciak:=1;
      for k:=1 to NumeroLineas do begin
        if (MinimDiferencia>Diferencia[k]) and (Diferencia[k]>0) then begin
          MinimDiferencia:=Diferencia[k];
          MinimDiferenciak:=k;
        end;
      end;
      {
      Canvas.Font.Color:=clBlack;
      Canvas.Font.Name:='CourierNew';
      Canvas.Font.Size:=128;
      Canvas.Brush.Style:=bsClear;
      }
      if MinimDiferenciak=1 then begin
        //if (EditV1.Text<>'') and (CheckBoxMostrarSoReconegut.Checked) then Canvas.textOut(ClientWidth div 2-Canvas.TextWidth(EditV1.Text) div 2,Panel1.Height,EditV1.Text);
        VocalReconegudaAnterior:=EditV1.Text;
        EditV1.Font.Color:=ClRed;
        EditV2.Font.Color:=ClBlack;
        EditV3.Font.Color:=ClBlack;
        EditV4.Font.Color:=ClBlack;
        EditV5.Font.Color:=ClBlack;
        EditV6.Font.Color:=ClBlack;
        EditV7.Font.Color:=ClBlack;
        EditV8.Font.Color:=ClBlack;
        EditV9.Font.Color:=ClBlack;
        EditV10.Font.Color:=ClBlack;
      end else if MinimDiferenciak=2 then begin
        //if (EditV2.Text<>'') and (CheckBoxMostrarSoReconegut.Checked) then Canvas.textOut(ClientWidth div 2-Canvas.TextWidth(EditV2.Text) div 2,Panel1.Height,EditV2.Text);
        VocalReconegudaAnterior:=EditV2.Text;
        EditV2.Font.Color:=ClRed;
        EditV1.Font.Color:=ClBlack;
        EditV3.Font.Color:=ClBlack;
        EditV4.Font.Color:=ClBlack;
        EditV5.Font.Color:=ClBlack;
        EditV6.Font.Color:=ClBlack;
        EditV7.Font.Color:=ClBlack;
        EditV8.Font.Color:=ClBlack;
        EditV9.Font.Color:=ClBlack;
        EditV10.Font.Color:=ClBlack;
      end else if MinimDiferenciak=3 then begin
        //if (EditV3.Text<>'') and (CheckBoxMostrarSoReconegut.Checked) then Canvas.textOut(ClientWidth div 2-Canvas.TextWidth(EditV3.Text) div 2,Panel1.Height,EditV3.Text);
        VocalReconegudaAnterior:=EditV3.Text;
        EditV3.Font.Color:=ClRed;
        EditV1.Font.Color:=ClBlack;
        EditV2.Font.Color:=ClBlack;
        EditV4.Font.Color:=ClBlack;
        EditV5.Font.Color:=ClBlack;
        EditV6.Font.Color:=ClBlack;
        EditV7.Font.Color:=ClBlack;
        EditV8.Font.Color:=ClBlack;
        EditV9.Font.Color:=ClBlack;
        EditV10.Font.Color:=ClBlack;
      end else if MinimDiferenciak=4 then begin
        //if (EditV4.Text<>'') and (CheckBoxMostrarSoReconegut.Checked) then Canvas.textOut(ClientWidth div 2-Canvas.TextWidth(EditV4.Text) div 2,Panel1.Height,EditV4.Text);
        VocalReconegudaAnterior:=EditV4.Text;
        EditV4.Font.Color:=ClRed;
        EditV1.Font.Color:=ClBlack;
        EditV2.Font.Color:=ClBlack;
        EditV3.Font.Color:=ClBlack;
        EditV5.Font.Color:=ClBlack;
        EditV6.Font.Color:=ClBlack;
        EditV7.Font.Color:=ClBlack;
        EditV8.Font.Color:=ClBlack;
        EditV9.Font.Color:=ClBlack;
        EditV10.Font.Color:=ClBlack;
      end else if MinimDiferenciak=5 then begin
        //if (EditV5.Text<>'') and (CheckBoxMostrarSoReconegut.Checked) then Canvas.textOut(ClientWidth div 2-Canvas.TextWidth(EditV5.Text) div 2,Panel1.Height,EditV5.Text);
        VocalReconegudaAnterior:=EditV5.Text;
        EditV5.Font.Color:=ClRed;
        EditV1.Font.Color:=ClBlack;
        EditV2.Font.Color:=ClBlack;
        EditV3.Font.Color:=ClBlack;
        EditV4.Font.Color:=ClBlack;
        EditV6.Font.Color:=ClBlack;
        EditV7.Font.Color:=ClBlack;
        EditV8.Font.Color:=ClBlack;
        EditV9.Font.Color:=ClBlack;
        EditV10.Font.Color:=ClBlack;
      end else if MinimDiferenciak=6 then begin
        //if (EditV6.Text<>'') and (CheckBoxMostrarSoReconegut.Checked) then Canvas.textOut(ClientWidth div 2-Canvas.TextWidth(EditV6.Text) div 2,Panel1.Height,EditV6.Text);
        VocalReconegudaAnterior:=EditV6.Text;
        EditV6.Font.Color:=ClRed;
        EditV1.Font.Color:=ClBlack;
        EditV2.Font.Color:=ClBlack;
        EditV3.Font.Color:=ClBlack;
        EditV4.Font.Color:=ClBlack;
        EditV5.Font.Color:=ClBlack;
        EditV7.Font.Color:=ClBlack;
        EditV8.Font.Color:=ClBlack;
        EditV9.Font.Color:=ClBlack;
        EditV10.Font.Color:=ClBlack;
      end else if MinimDiferenciak=7 then begin
        //if (EditV7.Text<>'') and (CheckBoxMostrarSoReconegut.Checked) then Canvas.textOut(ClientWidth div 2-Canvas.TextWidth(EditV7.Text) div 2,Panel1.Height,EditV7.Text);
        VocalReconegudaAnterior:=EditV7.Text;
        EditV7.Font.Color:=ClRed;
        EditV1.Font.Color:=ClBlack;
        EditV2.Font.Color:=ClBlack;
        EditV3.Font.Color:=ClBlack;
        EditV4.Font.Color:=ClBlack;
        EditV5.Font.Color:=ClBlack;
        EditV6.Font.Color:=ClBlack;
        EditV8.Font.Color:=ClBlack;
        EditV9.Font.Color:=ClBlack;
        EditV10.Font.Color:=ClBlack;
      end else if MinimDiferenciak=8 then begin
        //if (EditV8.Text<>'') and (CheckBoxMostrarSoReconegut.Checked) then Canvas.textOut(ClientWidth div 2-Canvas.TextWidth(EditV8.Text) div 2,Panel1.Height,EditV8.Text);
        VocalReconegudaAnterior:=EditV8.Text;
        EditV8.Font.Color:=ClRed;
        EditV1.Font.Color:=ClBlack;
        EditV2.Font.Color:=ClBlack;
        EditV3.Font.Color:=ClBlack;
        EditV4.Font.Color:=ClBlack;
        EditV5.Font.Color:=ClBlack;
        EditV6.Font.Color:=ClBlack;
        EditV7.Font.Color:=ClBlack;
        EditV9.Font.Color:=ClBlack;
        EditV10.Font.Color:=ClBlack;
      end else if MinimDiferenciak=9 then begin
        //if (EditV9.Text<>'') and (CheckBoxMostrarSoReconegut.Checked) then Canvas.textOut(ClientWidth div 2-Canvas.TextWidth(EditV9.Text) div 2,Panel1.Height,EditV9.Text);
        VocalReconegudaAnterior:=EditV9.Text;
        EditV9.Font.Color:=ClRed;
        EditV1.Font.Color:=ClBlack;
        EditV2.Font.Color:=ClBlack;
        EditV3.Font.Color:=ClBlack;
        EditV4.Font.Color:=ClBlack;
        EditV5.Font.Color:=ClBlack;
        EditV6.Font.Color:=ClBlack;
        EditV7.Font.Color:=ClBlack;
        EditV8.Font.Color:=ClBlack;
        EditV10.Font.Color:=ClBlack;
      end else if MinimDiferenciak=10 then begin
        //if (EditV10.Text<>'') and (CheckBoxMostrarSoReconegut.Checked) then Canvas.textOut(ClientWidth div 2-Canvas.TextWidth(EditV10.Text) div 2,Panel1.Height,EditV10.Text);
        VocalReconegudaAnterior:=EditV10.Text;
        EditV10.Font.Color:=ClRed;
        EditV1.Font.Color:=ClBlack;
        EditV2.Font.Color:=ClBlack;
        EditV3.Font.Color:=ClBlack;
        EditV4.Font.Color:=ClBlack;
        EditV5.Font.Color:=ClBlack;
        EditV6.Font.Color:=ClBlack;
        EditV7.Font.Color:=ClBlack;
        EditV8.Font.Color:=ClBlack;
        EditV9.Font.Color:=ClBlack;
      end;
    end;
  end;
end;

procedure TFormEspectroscopiLPC.ButtonGuardarPatronsClick(Sender: TObject);
var
  i,n:LongInt;
  Nom:string;
  TS:TStringList;
begin
  if NumeroLineas>0 then begin
    TS:=TStringList.Create;
    TS.Sorted:=false;
    TS.Add('Globus 3 - Projecte Fressa - (C) Jordi Lagares Roset - www.lagares.org');
    TS.Add(AboutBox.Version.Caption);
    TS.Add('Comparaci de patrons');
    TS.Add(IntToStr(NumeroLineas));
    TS.Add(IntToStr(NumeroQuoeficientsLPC));
    if MenuEscalaYDecibels.Checked then TS.Add(IntToStr(1)) else TS.Add(IntToStr(0));
    if MenuPreenfasis.Checked then TS.Add(IntToStr(1)) else TS.Add(IntToStr(0));
    if MenuNormalitzarPerMaxim.Checked then TS.Add(IntToStr(1)) else TS.Add(IntToStr(0));
    if CheckBoxMel.Checked then TS.Add(IntToStr(1)) else TS.Add(IntToStr(0));
    TS.Add(EditV1.Text);
    TS.Add(EditV2.Text);
    TS.Add(EditV3.Text);
    TS.Add(EditV4.Text);
    TS.Add(EditV5.Text);
    TS.Add(EditV6.Text);
    TS.Add(EditV7.Text);
    TS.Add(EditV8.Text);
    TS.Add(EditV9.Text);
    TS.Add(EditV10.Text);
    for i:=1 to NumeroLineas do begin
      TS.Add(IntToStr(ColorLineas[i]));
      for n:=1 to GrandariaNumerosBufferEntradaDeSo do TS.Add(IntToStr(Numeros[i,n]));
    end;
    if SaveDialog.Execute then begin
      Nom:=SaveDialog.Filename;
      if Pos('.patroglobus',Copy(Nom,length(Nom)-11,12))=0 then Nom:=Nom+'.patroglobus';
      TS.SaveToFile(nom);
    end;
    TS.Free;
  end;
end;

procedure TFormEspectroscopiLPC.ButonObrirPatronsClick(Sender: TObject);
var
  i,n,k:LongInt;
  Nom:string;
  TS:TStringList;
  Versio:string;
  NumeroLineasFinal:integer;
  NumCoef:integer;
  EsCorrecte:integer;
begin
  if OpenDialog.Execute then begin
    Cursor:=CrHourGlass;
    TS:=TStringList.Create;
    TS.Sorted:=false;
    Nom:=OpenDialog.Filename;
    TS.LoadFromFile(nom);
    EsCorrecte:=0;
    try
      if TS.Strings[0]<>'Globus 3 - Projecte Fressa - (C) Jordi Lagares Roset - www.lagares.org' then EsCorrecte:=1;
      if EsCorrecte=0 then begin
        Versio:=TS.Strings[1];
        if TS.Strings[2]<>'Comparaci de patrons' then EsCorrecte:=2;
      end;
      if EsCorrecte=0 then begin
        NumeroLineasFinal:=StrToInt(TS.Strings[3]);
        if (NumeroLineasFinal<=0) or (NumeroLineasFinal>100) then EsCorrecte:=3;
      end;
      if EsCorrecte=0 then begin
        NumCoef:=StrToInt(TS.Strings[4]);
        if not((NumCoef>=SpinEditNumeroQuoeficients.MinValue) and (NumCoef<=SpinEditNumeroQuoeficients.MaxValue)) then EsCorrecte:=4;
      end;
      if EsCorrecte=0 then begin
        if StrToInt(TS.Strings[5])=1 then MenuEscalaYDecibels.Checked:=true else MenuEscalaYDecibels.Checked:=false;
        if StrToInt(TS.Strings[6])=1 then MenuPreenfasis.Checked:=true else MenuPreenfasis.Checked:=false;
        if StrToInt(TS.Strings[7])=1 then MenuNormalitzarPerMaxim.Checked:=true else MenuNormalitzarPerMaxim.Checked:=false;
        if StrToInt(TS.Strings[8])=1 then CheckBoxMel.Checked:=true else CheckBoxMel.Checked:=false;
        EditV1.Text:=TS.Strings[9];
        EditV2.Text:=TS.Strings[10];
        EditV3.Text:=TS.Strings[11];
        EditV4.Text:=TS.Strings[12];
        EditV5.Text:=TS.Strings[13];
        EditV6.Text:=TS.Strings[14];
        EditV7.Text:=TS.Strings[15];
        EditV8.Text:=TS.Strings[16];
        EditV9.Text:=TS.Strings[17];
        EditV10.Text:=TS.Strings[18];
      end;
    except
      EsCorrecte:=5;
    end;
    if EsCorrecte=0 then begin
      try
        NumeroLineas:=NumeroLineasFinal;
        k:=19;
        for i:=1 to NumeroLineas do begin
          ColorLineas[i]:=StrToInt(TS.Strings[k]);
          inc(k);
          for n:=1 to GrandariaNumerosBufferEntradaDeSo do begin
            Numeros[i,n]:=StrToInt(TS.Strings[k]);
            inc(k);
          end;
        end;
        SpinEditNumeroQuoeficients.Value:=NumCoef;
        for i:=1 to GrandariaNumerosBufferEntradaDeSo do Numeros[0,i]:=0;
        ValorMaximDelSo:=0;
        //Pintar;
      except
        EsCorrecte:=6;
      end;
    end;
    TS.Free;
    VocalReconegudaAnterior:='';
    Repaint;
    Cursor:=CrDefault;
    if EsCorrecte>0 then ShowMessage(Caption+'. '+FormPrincipal.Missatges[1]+'. Error n: '+IntToStr(EsCorrecte));
  end;
end;

procedure TFormEspectroscopiLPC.SpeedButtonCaixaEinesClick(Sender: TObject);
begin
  FormCanviDeParametres.ShowModal;
end;

procedure TFormEspectroscopiLPC.CheckBoxEscalaMelLinealClick(Sender: TObject);
begin
  Repaint;
end;

procedure TFormEspectroscopiLPC.FormMouseDown(Sender: TObject;Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbleft then begin
    ButtonCongelarClick(nil);
  end else begin
    if SpeedButtonEngegarParar.Down then begin
      FinalitzarEntradaDeSo;
      SpeedButtonEngegarParar.Caption:='E';
      SpeedButtonEngegarParar.Down:=false;
      SpeedButtonEngegarParar.Enabled:=true;
    end;
  end;
end;

procedure TFormEspectroscopiLPC.FormMouseMove(Sender: TObject;Shift: TShiftState; X, Y: Integer);
var
  StrFrec:string;
begin
  Canvas.Brush.Style:=bsSolid;
  Canvas.Font.Size:=SizeText;
  Canvas.Font.Color:=clBlack;
  //Canvas.TextOut(10,40,IntToStr(Round(x/100*UnitatEixX)));
  if CheckBoxMel.Checked then begin
    //Invers escala mel f = 700 [exp(m / 1127) - 1]
    str(700*(exp(x/100*UnitatEixX/1127)-1):4:0,StrFrec);
  end else begin
    StrFrec:=IntToStr(Round(x/100*UnitatEixX));
  end;
  Canvas.TextOut(5,40,StrFrec+'      ');
end;

procedure TFormEspectroscopiLPC.LabelColorLineaMouseUp(Sender: TObject;Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbRight then begin
    ColorLineas[0]:=ClBlack;
    LabelColorLinea.Color:=ClBlack;
  end;
end;

end.
